/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.domsec.DomainSecurityIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class PasswordValidation
implements DomainSecurityIds {
    private static final String TRACE_MASKT = "XFT   LT";
    private static final String TRACE_MASKF = "XFT   LF";
    private static final String TRACE_MASKD = "XFT   LD";

    public static boolean isPasswordValid(String newPassword) {
        Trace.trace(TRACE_MASKT, "-> PasswordValidation.isPasswordValid()");
        boolean isValid = true;
        boolean oneNumeric = false;
        if (newPassword != null && newPassword.length() > 0) {
            if (newPassword.length() < 6 || newPassword.length() > 8) {
                isValid = PasswordValidation.displayMessage("HACA8003", "HACA0003", null);
            } else if (newPassword.charAt(0) >= '0' && newPassword.charAt(0) <= '9' || newPassword.charAt(newPassword.length() - 1) >= '0' && newPassword.charAt(newPassword.length() - 1) <= '9') {
                isValid = PasswordValidation.displayMessage("HACA8007", "HACA0007", null);
            } else {
                for (int i = 0; i < newPassword.length() && isValid; ++i) {
                    if (!(newPassword.charAt(i) >= 'A' && newPassword.charAt(i) <= 'Z' || newPassword.charAt(i) >= 'a' && newPassword.charAt(i) <= 'z' || newPassword.charAt(i) >= '0' && newPassword.charAt(i) <= '9')) {
                        isValid = PasswordValidation.displayMessage("HACA8005", "HACA0005", null);
                        continue;
                    }
                    if (i < newPassword.length() - 2 && newPassword.charAt(i) == newPassword.charAt(i + 1) && newPassword.charAt(i + 1) == newPassword.charAt(i + 2)) {
                        isValid = PasswordValidation.displayMessage("HACA8006", "HACA0006", null);
                        continue;
                    }
                    if (newPassword.charAt(i) < '0' || newPassword.charAt(i) > '9') continue;
                    oneNumeric = true;
                }
                if (isValid && !oneNumeric) {
                    isValid = PasswordValidation.displayMessage("HACA8007", "HACA0007", null);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PasswordValidation.isPasswordValid() - " + isValid + ".");
        return isValid;
    }

    public static boolean isNonStrictPasswordValid(String newPassword) {
        Trace.trace(TRACE_MASKT, "-> PasswordValidation.isNonStrictPasswordValid()");
        boolean isValid = true;
        boolean oneNumeric = false;
        if (newPassword != null && newPassword.length() > 0) {
            if (newPassword.length() < 4 || newPassword.length() > 8) {
                isValid = PasswordValidation.displayMessage("HACA8003", "HACA000P", null);
            } else {
                for (int i = 0; i < newPassword.length() && isValid; ++i) {
                    if (newPassword.charAt(i) >= 'A' && newPassword.charAt(i) <= 'Z' || newPassword.charAt(i) >= 'a' && newPassword.charAt(i) <= 'z' || newPassword.charAt(i) >= '0' && newPassword.charAt(i) <= '9') continue;
                    isValid = PasswordValidation.displayMessage("HACA8005", "HACA000O", null);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PasswordValidation.isNonStrictPasswordValid() - " + isValid + ".");
        return isValid;
    }

    private static boolean displayMessage(String t, String m, String sub) {
        Trace.trace(TRACE_MASKF, "-> PasswordValidation.displayMessage(" + m + ".");
        Object[] s = new String[]{sub};
        BaseMessageText text = new BaseMessageText(m, s);
        BaseMessageTitle title = new BaseMessageTitle(t);
        try {
            LocalizableText result = CommonMsgApp.showMessageBox(null, title, text);
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, "HException thrown by CommonMsgApp.");
        }
        Trace.trace(TRACE_MASKF, "<- PasswordValidation.displayMessage().");
        return false;
    }
}

